/**
 * 
 */
package de.consist.bmu.rule;

import java.util.Date;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import de.consist.bmu.rule.impl.SignatureVerificationResultImpl;

/**
 * @author srossbroich
 * 
 */
@XmlJavaTypeAdapter(SignatureVerificationResultImpl.Adapter.class)
public interface SignatureVerificationResult {

    /**
     * Enumeration des Pruefstatus der Signatur.
     */
    public enum VerificationStatus {
        /** Nicht verifiziert. */
        UNCHECKED,
        /** Gueltig. */
        VALID,
        /** Ungueltig. */
        INVALID
    };

    /**
     * @return Die Signatur-ID
     */
    String getSignatureID();

    /**
     * @return Das Pruefergebnis
     */
    VerificationStatus getVerificationStatus();

    /**
     * @param status
     *            Der Status der Signaturpruefung
     */
    void setVerificationStatus(VerificationStatus status);

    /**
     * @return Der Name des Unterzeichners
     */
    String getSubjectDN();

    /**
     * @return Der Signaturzeitpunkt aus der Xades-Erweiterung
     */
    Date getSigningTime();

    /**
     * @return Gibt zurueck, ob es sich um eine eIDAS-konforme Signatur handelt.
     */
    boolean isEIDAS();

    /**
     * @return Gibt zurueck, ob die Signatur mit der uebergebenen Regel geprueft werden soll.
     */
    boolean isEnabled(RuleDef ruleDef);
}
