/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplPostfachAdresse extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final String XPATH_POSTFACH = "/descendant::lib:Postfach";
    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplPostfachAdresse(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
//        RuleResult ruleResult = null;
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), XPATH_POSTFACH);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); i++) {
            Element pf = (Element) nl.item(i);
            Node parentNode = pf.getParentNode();
            if (!"Postfach".equals(parentNode.getLocalName())) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, parentNode.getParentNode().getNodeName()));
            }
        }
//        if (XPathFassade.getInstance().evalBool(
//                bmuDok.getDocument().getDocumentElement(),
//                XPATH_POSTFACH)) {
//            ruleResult = new RuleResultImpl(this.getRuleDef(), 1, null);
//        }
//        if (ruleResult != null) {
//            ruleResultList.add(ruleResult);
//        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "XPath fr die Prfung: " + XPATH_POSTFACH;
    }

}
